/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util.autoupdates;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.util.autoupdates.DownloadStatusMonitor;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiim.OiimARUConnection;
import oracle.sysman.oii.oiim.OiimARUOrionConnection;
import oracle.sysman.oii.oiim.OiimDownloadProgressStatusHolder;

public class DownloadUpdateJob
extends CompositeJob {
    private String destDir;
    List patches;
    private Logger logger = Logger.getLogger(DownloadUpdateJob.class.getName());
    private String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");
    private String shiphomeUpdatesDir = "LatestUpdates" + File.separator + "Shiphome";
    private String oneOffsDir = "LatestUpdates" + File.separator + "OneOffs";
    private String cpuUpdatesDir = "LatestUpdates" + File.separator + "CPUs";
    private OneOffsJob oneOffsJob;
    private CPUJob cpuUpdatesJob;
    private ShiphomeUpdatesJob shiphomeUpdatesJob;
    private long totalDownloadSize = 0L;
    private boolean useOldConn = false;

    public DownloadUpdateJob(String destDir, List patches) {
        super((Object)"download updates", "Downloading Updates", 1.0f);
        this.destDir = destDir != null && destDir.length() > 0 ? destDir : this.scratchPathLoc;
        this.patches = patches;
        String useOldConnProperty = System.getProperty("USE_ARU_CONNECTION");
        if (useOldConnProperty != null && useOldConnProperty.equalsIgnoreCase("true")) {
            this.useOldConn = true;
        }
    }

    public void setDownloadLoc(String loc) {
        if (loc != null && loc.length() > 0) {
            this.destDir = loc;
        }
    }

    public String getTotalSizeInUnits() {
        String s = "";
        if (this.totalDownloadSize != 0L) {
            s = Long.toString(this.totalDownloadSize) + " MB";
            if (this.totalDownloadSize > 1024L && this.totalDownloadSize < 0x100000L) {
                this.totalDownloadSize /= 1024L;
                s = Long.toString(this.totalDownloadSize) + " GB";
            } else if (this.totalDownloadSize >= 0x100000L) {
                this.totalDownloadSize /= 0x100000L;
                s = Long.toString(this.totalDownloadSize) + " TB";
            }
        }
        return s;
    }

    public int getBytesDownloaded() {
        long downloadedSize = 0L;
        if (this.oneOffsJob != null) {
            downloadedSize += this.oneOffsJob.getBytesDownloaded();
        }
        if (this.shiphomeUpdatesJob != null) {
            downloadedSize += this.shiphomeUpdatesJob.getBytesDownloaded();
        }
        if (this.cpuUpdatesJob != null) {
            downloadedSize += this.cpuUpdatesJob.getBytesDownloaded();
        }
        return (int)downloadedSize;
    }

    public void prepareJob(List patches) {
        ArrayList<OiiiPatchMetadata> oneOffUpdates = new ArrayList<OiiiPatchMetadata>();
        ArrayList<OiiiPatchMetadata> shiphomeUpdates = new ArrayList<OiiiPatchMetadata>();
        ArrayList cpuUpdates = new ArrayList();
        File f1 = new File(this.destDir, this.oneOffsDir);
        File f2 = new File(this.destDir, this.shiphomeUpdatesDir);
        File f3 = new File(this.destDir, this.cpuUpdatesDir);
        if (patches != null && patches.size() > 0) {
            for (Object d : patches) {
                if (!(d instanceof OiiiPatchMetadata)) continue;
                if (((OiiiPatchMetadata)d).getType() == "patch" || ((OiiiPatchMetadata)d).getType() == "patchset") {
                    oneOffUpdates.add((OiiiPatchMetadata)d);
                    continue;
                }
                if (((OiiiPatchMetadata)d).getType() == "shiphome" || ((OiiiPatchMetadata)d).getType() == "oui" || ((OiiiPatchMetadata)d).getType() == "opatch") {
                    shiphomeUpdates.add((OiiiPatchMetadata)d);
                    continue;
                }
                if (((OiiiPatchMetadata)d).getType() != "cpus") continue;
                cpuUpdates.add(d);
            }
        }
        if (!f1.exists() && oneOffUpdates != null && oneOffUpdates.size() > 0) {
            this.oneOffsJob = new OneOffsJob(oneOffUpdates, this.destDir);
            this.add(this.oneOffsJob);
        }
        if (!f2.exists() && shiphomeUpdates != null && shiphomeUpdates.size() > 0) {
            this.shiphomeUpdatesJob = new ShiphomeUpdatesJob(shiphomeUpdates, this.destDir);
            this.add(this.shiphomeUpdatesJob);
        }
        if (!f3.exists() && cpuUpdates != null && cpuUpdates.size() > 0) {
            this.cpuUpdatesJob = new CPUJob(cpuUpdates, this.destDir);
            this.add(this.cpuUpdatesJob);
        }
    }

    public void cancelAllDownloads() {
        this.setStatus(Status.FAILED);
        if (this.useOldConn) {
            OiimARUConnection.cancelAllDownloads();
        } else {
            OiimARUOrionConnection.cancelAllDownloads();
        }
    }

    class CPUJob
    extends Job
    implements Callable {
        ArrayList cpuUpdates;
        private String destDir;
        private DownloadStatusMonitor cpuUpdatesProgress;
        ValidationStatusMessage msg;
        long totalSize = 0L;
        long downloadedSize = 0L;
        private ReentrantLock lock = new ReentrantLock();
        private Condition condition = this.lock.newCondition();

        public CPUJob(ArrayList cpuUpdates, String destDir) {
            this.setDescription("CPU Download Job");
            this.cpuUpdates = cpuUpdates;
            this.destDir = destDir;
            this.cpuUpdatesProgress = new DownloadStatusMonitor(this.lock, this.condition, this.downloadedSize);
        }

        public ValidationStatusMessage getReturnStatus() {
            return this.msg;
        }

        public Callable<?> getWork() {
            return this;
        }

        public long getPercentComplete() {
            return this.cpuUpdatesProgress.getPercentComplete();
        }

        public long getTotalSizeInBytes() {
            return this.totalSize;
        }

        public long getBytesDownloaded() {
            if (this.cpuUpdatesProgress != null) {
                this.downloadedSize = this.cpuUpdatesProgress.getBytesDownloaded();
            }
            return this.downloadedSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Void call() throws Exception {
            this.setStatus(Status.INPROGRESS);
            if (this.cpuUpdates != null && this.cpuUpdates.size() > 0) {
                boolean dwldStatus = false;
                dwldStatus = DownloadUpdateJob.this.useOldConn ? OiimARUConnection.downloadCPUs((ArrayList)this.cpuUpdates, (OiimDownloadProgressStatusHolder)this.cpuUpdatesProgress, (String)this.destDir) : OiimARUOrionConnection.downloadCPUs((ArrayList)this.cpuUpdates, (OiimDownloadProgressStatusHolder)this.cpuUpdatesProgress, (String)this.destDir);
                if (dwldStatus) {
                    this.totalSize = this.cpuUpdatesProgress.getTotalSizeInBytes();
                    this.lock.lock();
                    try {
                        while (this.cpuUpdatesProgress.getStatus() != 4L && this.cpuUpdatesProgress.getStatus() != 3L) {
                            this.condition.await();
                        }
                        if (this.cpuUpdatesProgress.getStatus() == 4L || this.cpuUpdatesProgress.getStatus() == 5L) {
                            this.setStatus(Status.FAILED);
                            return null;
                        }
                        if (this.cpuUpdatesProgress.getStatus() != 3L) return null;
                        this.setStatus(Status.SUCCEEDED);
                        return null;
                    }
                    catch (Exception e) {
                        DownloadUpdateJob.this.logger.log(Level.WARNING, "Exception occurred while waiting on re-entrant lock", e);
                        this.setStatus(Status.FAILED);
                        return null;
                    }
                    finally {
                        this.lock.unlock();
                    }
                } else {
                    this.setStatus(Status.FAILED);
                }
                return null;
            } else {
                this.setStatus(Status.SUCCEEDED);
            }
            return null;
        }
    }

    class ShiphomeUpdatesJob
    extends Job
    implements Callable {
        ArrayList<OiiiPatchMetadata> shiphomeUpdates;
        private String destDir;
        private DownloadStatusMonitor shiphomeUpdatesProgress;
        ValidationStatusMessage msg;
        long totalSize = 0L;
        long downloadedSize = 0L;
        private ReentrantLock lock = new ReentrantLock();
        private Condition condition = this.lock.newCondition();

        public ShiphomeUpdatesJob(ArrayList<OiiiPatchMetadata> shiphomeUpdates, String destDir) {
            this.setDescription("Shiphome Updates Download Job");
            this.shiphomeUpdates = shiphomeUpdates;
            this.destDir = destDir;
            this.shiphomeUpdatesProgress = new DownloadStatusMonitor(this.lock, this.condition, this.downloadedSize);
        }

        public ValidationStatusMessage getReturnStatus() {
            return this.msg;
        }

        public Callable<?> getWork() {
            return this;
        }

        public long getPercentComplete() {
            return this.shiphomeUpdatesProgress.getPercentComplete();
        }

        public long getTotalSizeInBytes() {
            return this.totalSize;
        }

        public long getBytesDownloaded() {
            if (this.shiphomeUpdatesProgress != null) {
                this.downloadedSize = this.shiphomeUpdatesProgress.getBytesDownloaded();
            }
            return this.downloadedSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Void call() throws Exception {
            this.setStatus(Status.INPROGRESS);
            if (this.shiphomeUpdates != null && this.shiphomeUpdates.size() > 0) {
                boolean dwldStatus = false;
                dwldStatus = DownloadUpdateJob.this.useOldConn ? OiimARUConnection.downloadUpdates(this.shiphomeUpdates, (OiimDownloadProgressStatusHolder)this.shiphomeUpdatesProgress, (String)this.destDir) : OiimARUOrionConnection.downloadUpdates(this.shiphomeUpdates, (OiimDownloadProgressStatusHolder)this.shiphomeUpdatesProgress, (String)this.destDir);
                if (dwldStatus) {
                    this.totalSize = this.shiphomeUpdatesProgress.getTotalSizeInBytes();
                    this.lock.lock();
                    try {
                        while (this.shiphomeUpdatesProgress.getStatus() != 4L && this.shiphomeUpdatesProgress.getStatus() != 3L) {
                            this.condition.await();
                        }
                        if (this.shiphomeUpdatesProgress.getStatus() == 4L || this.shiphomeUpdatesProgress.getStatus() == 5L) {
                            this.setStatus(Status.FAILED);
                            return null;
                        }
                        if (this.shiphomeUpdatesProgress.getStatus() != 3L) return null;
                        this.setStatus(Status.SUCCEEDED);
                        return null;
                    }
                    catch (Exception e) {
                        DownloadUpdateJob.this.logger.log(Level.WARNING, "Exception occurred while waiting on re-entrant lock", e);
                        this.setStatus(Status.FAILED);
                        return null;
                    }
                    finally {
                        this.lock.unlock();
                    }
                } else {
                    this.setStatus(Status.FAILED);
                }
                return null;
            } else {
                this.setStatus(Status.SUCCEEDED);
            }
            return null;
        }
    }

    class OneOffsJob
    extends Job
    implements Callable {
        ArrayList<OiiiPatchMetadata> oneOffUpdates;
        private String destDir;
        private DownloadStatusMonitor oneOffsProgress;
        ValidationStatusMessage msg;
        long totalSize = 0L;
        long downloadedSize = 0L;
        private ReentrantLock lock = new ReentrantLock();
        private Condition condition = this.lock.newCondition();

        public OneOffsJob(ArrayList<OiiiPatchMetadata> oneOffUpdates, String destDir) {
            this.setDescription("OneOffs Download Job");
            this.oneOffUpdates = oneOffUpdates;
            this.destDir = destDir;
            this.oneOffsProgress = new DownloadStatusMonitor(this.lock, this.condition, this.downloadedSize);
        }

        public long getTotalSizeInBytes() {
            return this.totalSize;
        }

        public long getBytesDownloaded() {
            if (this.oneOffsProgress != null) {
                this.downloadedSize = this.oneOffsProgress.getBytesDownloaded();
            }
            return this.downloadedSize;
        }

        public long getPercentComplete() {
            return this.oneOffsProgress.getPercentComplete();
        }

        public ValidationStatusMessage getReturnStatus() {
            return this.msg;
        }

        public Callable<?> getWork() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Void call() throws Exception {
            this.setStatus(Status.INPROGRESS);
            if (this.oneOffUpdates != null && this.oneOffUpdates.size() > 0) {
                boolean dwldStatus = false;
                dwldStatus = DownloadUpdateJob.this.useOldConn ? OiimARUConnection.downloadOneOff(this.oneOffUpdates, (OiimDownloadProgressStatusHolder)this.oneOffsProgress, (String)this.destDir) : OiimARUOrionConnection.downloadOneOff(this.oneOffUpdates, (OiimDownloadProgressStatusHolder)this.oneOffsProgress, (String)this.destDir);
                if (dwldStatus) {
                    this.totalSize = this.oneOffsProgress.getTotalSizeInBytes();
                    this.lock.lock();
                    try {
                        while (this.oneOffsProgress.getStatus() != 4L && this.oneOffsProgress.getStatus() != 3L) {
                            this.condition.await();
                        }
                        if (this.oneOffsProgress.getStatus() == 4L || this.oneOffsProgress.getStatus() == 5L) {
                            this.setStatus(Status.FAILED);
                            return null;
                        }
                        if (this.oneOffsProgress.getStatus() != 3L) return null;
                        this.setStatus(Status.SUCCEEDED);
                        return null;
                    }
                    catch (Exception e) {
                        DownloadUpdateJob.this.logger.log(Level.WARNING, "Exception occurred while waiting on re-entrant lock", e);
                        this.setStatus(Status.FAILED);
                        return null;
                    }
                    finally {
                        this.lock.unlock();
                    }
                } else {
                    this.setStatus(Status.FAILED);
                }
                return null;
            } else {
                this.setStatus(Status.SUCCEEDED);
            }
            return null;
        }
    }
}

